;; Analiza danych i definicje:
(define-struct uczen (imie nazwisko wychowawca))
;; uczen jest struktur: (make-uczen i n w), gdzie i, n i w s symbolami.

;; Kontrakt: zmien-wychowawce : uczen symbol -> uczen

;; Cel: stworzenie struktury uczen z nowym nazwiskiem wychowawcy, jeli obecny wychowawca nazywa si Nowak

;; Przykady:
;; (zmien-wychowawce (make-uczen 'Jan 'Kowalski 'Nowak) 'Miller)
;; =
;; (make-uczen 'Jan 'Kowalski 'Miller)

;; (zmien-wychowawce (make-uczen 'Jan 'Kowalski 'Wojciechowski) 'Miller)
;; =
;; (make-uczen 'Jan 'Kowalski 'Wojciechowski)

;; Szablon:
;; (define (przetwarzaj-uczen dany-uczen dany-wychowawca) 
;; ... (uczen-imie dany-uczen) ...
;; ... (uczen-nazwisko dany-uczen) ...
;; ... (uczen-wychowawca dany-uczen) ...)

;; Definicja:
(define (zmien-wychowawce dany-uczen dany-wychowawca) 
  (cond
    [(symbol=? (uczen-wychowawca dany-uczen) 'Nowak) 
      (make-uczen (uczen-imie dany-uczen)
                  (uczen-nazwisko dany-uczen)
		         dany-wychowawca)]
    [else dany-uczen]))
  
;; Testy:
;; (zmien-wychowawce (make-uczen 'Jan 'Kowalski 'Nowak) 'Miller)
;; oczekiwana warto:
;; (make-uczen 'Jan 'Kowalski 'Miller)

;; (zmien-wychowawce (make-uczen 'Jan 'Kowalski 'Wojciechowski) 'Miller)
;; oczekiwana warto:
;; (make-uczen 'Jan 'Kowalski 'Wojciechowski)
